<!DOCTYPE html>
<html lang="fr">
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>billets_affiche</title>
<head>
    <?php
    session_start();

    // Connexion à la base de données
    $db=new PDO('mysql:host=localhost;dbname=nkodiadiabate_blog;port=3306;charset=utf8', 'nkodiadiabate', 'bd4FEtDMixSDgKm');
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Vérification de la présence de l'ID du billet dans l'URL
    if (isset($_GET['id'])) {
        $id = $_GET['id'];

        // Préparation de la requête pour obtenir le billet complet
        $requete = "SELECT * FROM billets WHERE id_billet = :id";
        $stmt = $db->prepare($requete);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        // Récupération du billet
        $billet = $stmt->fetch(PDO::FETCH_ASSOC);
    ?>
</head>
<body>
    <a href="index.php" class="back-link">Retour à l'accueil</a>

    <?php
    echo "<div class='blog-post'>
            <h2>{$billet['titre']}</h2>
            <p>{$billet['contenu']}</p>
            <p class='date'>{$billet['date_post']}</p>";
    ?>

    <!-- Bouton pour afficher les commentaires -->
    <button id="toggle-comments">Afficher les commentaires</button>

    <!-- Section des commentaires -->
    <div id="comment-section" class="comment-section" style="display: none;">
        <h1>Commentaires</h1>
        <?php
        $requete = "SELECT * FROM commentaires WHERE id_billet = :id";
        $stmt = $db->prepare($requete);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        foreach ($result as $commentaires) {
            echo "<div class='comment'>
                    <h3 class='comment-author'>Auteur : {$commentaires["id_auteur"]}</h3>
                    <p class='comment-text'>{$commentaires["contenu"]}</p>
                  </div>";
        }
        ?>
    </div>

    <?php
        if (isset($_SESSION["login"]))
        { 
            echo "
            <div class='comment-form'>
                <form action='traite_com.php' method='POST'>
                    <label for='contenu'>Écrivez votre contenu</label><br>
                    <input name='contenu' type='text' required><br>
                    <input type='submit' value='Ajouter un commentaire'>
                    <input type='hidden' name='id_billet' value=$id>
                </form>
            </div>";
        } else {
            echo "Vous ne pouvez pas ajouter un commentaire, vous n'êtes pas connecté.";
            echo "<a href='login.php'>Connectez-vous</a>";
        }
    ?>
</div>

<script>
    // Script pour afficher ou masquer les commentaires
    document.getElementById('toggle-comments').addEventListener('click', function() {
        const commentSection = document.getElementById('comment-section');
        if (commentSection.style.display === 'none' || commentSection.style.display === '') {
            commentSection.style.display = 'block';
            this.textContent = 'Masquer les commentaires';
        } else {
            commentSection.style.display = 'none';
            this.textContent = 'Afficher les commentaires';
        }
    });
</script>



<style>
                .blog-post {
                    background-color: #ffffff;
                    border-radius: 8px;
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
                    padding: 20px;
                    margin-bottom: 20px;
                    max-width: 800px;
                    margin: auto;
                }
                .blog-post h2 {
                    font-size: 26px;
                    color: #2c3e50;
                }
                .blog-post p {
                    font-size: 16px;
                    line-height: 1.6;
                    color: #333333;
                }
                .back-link {
                    display: inline-block;
                    margin-top: 15px;
                    padding: 10px 20px;
                    font-size: 16px;
                    color: #3498db;
                    text-decoration: none;
                    border: 2px solid #3498db;
                    border-radius: 5px;
                }
                .back-link:hover {
                    background-color: #3498db;
                    color: #ffffff;
                }

                .comment-section {
    background-color: #f9f9fb;
    border-radius: 8px;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    padding: 20px;
    margin-top: 30px;
    max-width: 800px;
    margin: auto;
}

.comment-section h3 {
    font-size: 22px;
    color: #2c3e50;
    margin-bottom: 20px;
}

.comment {
    border-bottom: 1px solid #e0e0e0;
    padding: 15px 0;
}

.comment:last-child {
    border-bottom: none;
}

.comment-author {
    font-weight: bold;
    color: #3498db;
    margin-bottom: 5px;
}

.comment-date {
    font-size: 14px;
    color: #999999;
    margin-bottom: 10px;
}

.comment-text {
    font-size: 16px;
    line-height: 1.6;
    color: #333333;
}

/* Style du formulaire de commentaire */
.comment-form {
    margin-top: 20px;
}

.comment-form textarea {
    width: 100%;
    padding: 10px;
    font-size: 16px;
    border: 1px solid #dddddd;
    border-radius: 5px;
    resize: vertical;
    margin-bottom: 10px;
}

.comment-form input[type="submit"] {
    background-color: #3498db;
    color: #ffffff;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s;
}

.comment-form input[type="submit"]:hover {
    background-color: #2980b9;
}
</style>
</body>
</html>
<?php
}
?>